/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.ugens.UGen;

public class ADSR
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    private float beforeAmplitude;
    private float afterAmplitude;
    private float maxAmplitude;
    private float amplitude;
    private float attackTime;
    private float decayTime;
    private float sustainLevel;
    private float releaseTime;
    private float timeStepSize;
    private float timeFromOn;
    private float timeFromOff;
    private boolean isTurnedOn;
    private boolean isTurnedOff;
    private boolean unpatchAfterRelease;
    private AudioOutput output;
    private UGen ugenOutput;

    public ADSR() {
        this(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float f) {
        this(f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float f, float f2) {
        this(f, f2, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float f, float f2, float f3) {
        this(f, f2, f3, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, 1.0f, 0.0f, 0.0f);
    }

    public ADSR(float f, float f2, float f3, float f4, float f5) {
        this(f, f2, f3, f4, f5, 0.0f, 0.0f);
    }

    public ADSR(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f3, f4, f5, f6, 0.0f);
    }

    public ADSR(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.maxAmplitude = f;
        this.attackTime = f2;
        this.decayTime = f3;
        this.sustainLevel = f4;
        this.releaseTime = f5;
        this.beforeAmplitude = f6;
        this.afterAmplitude = f7;
        this.amplitude = this.beforeAmplitude;
        this.isTurnedOn = false;
        this.isTurnedOff = false;
        this.timeFromOn = -1.0f;
        this.timeFromOff = -1.0f;
        this.unpatchAfterRelease = false;
    }

    public void setParameters(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.maxAmplitude = f;
        this.attackTime = f2;
        this.decayTime = f3;
        this.sustainLevel = f4;
        this.releaseTime = f5;
        this.beforeAmplitude = f6;
        this.afterAmplitude = f7;
    }

    public void noteOn() {
        this.timeFromOn = 0.0f;
        this.isTurnedOn = true;
        this.timeFromOff = -1.0f;
        this.isTurnedOff = false;
    }

    public void noteOff() {
        this.timeFromOff = 0.0f;
        this.isTurnedOff = true;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    public void unpatchAfterRelease(AudioOutput audioOutput) {
        this.unpatchAfterRelease = true;
        this.output = audioOutput;
    }

    public void unpatchAfterRelease(UGen uGen) {
        this.unpatchAfterRelease = true;
        this.ugenOutput = uGen;
    }

    @Override
    protected void uGenerate(float[] fArray) {
        block13: {
            float f;
            block14: {
                block12: {
                    if (this.isTurnedOn) break block12;
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = this.beforeAmplitude * this.audio.getLastValues()[i];
                    }
                    break block13;
                }
                if (!(this.timeFromOff > this.releaseTime)) break block14;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.afterAmplitude * this.audio.getLastValues()[i];
                }
                if (!this.unpatchAfterRelease) break block13;
                if (this.output != null) {
                    this.unpatch(this.output);
                    this.output = null;
                }
                if (this.ugenOutput != null) {
                    this.unpatch(this.ugenOutput);
                    this.ugenOutput = null;
                }
                this.unpatchAfterRelease = false;
                break block13;
            }
            if (this.isTurnedOn && !this.isTurnedOff) {
                if (this.timeFromOn <= this.attackTime) {
                    f = this.attackTime - this.timeFromOn;
                    this.amplitude += (this.maxAmplitude - this.amplitude) * this.timeStepSize / f;
                } else if (this.timeFromOn > this.attackTime && this.timeFromOn <= this.attackTime + this.decayTime) {
                    f = this.attackTime + this.decayTime - this.timeFromOn;
                    this.amplitude += (this.sustainLevel * this.maxAmplitude - this.amplitude) * this.timeStepSize / f;
                } else if (this.timeFromOn > this.attackTime + this.decayTime) {
                    this.amplitude = this.sustainLevel * this.maxAmplitude;
                }
                this.timeFromOn += this.timeStepSize;
            } else {
                f = this.releaseTime - this.timeFromOff;
                this.amplitude += (this.afterAmplitude - this.amplitude) * this.timeStepSize / f;
                this.timeFromOff += this.timeStepSize;
            }
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.amplitude * this.audio.getLastValues()[i];
            }
        }
    }
}

